require( "scripts/style.lua" );

HeaderFont = {
  standardFont,
  36,
  RedColor
};


GameModeFont = {
  standardFont,
  35,
  RedColor
};

TableInfoFont = {
  standardFont,
  30,
  BorderColor
};

EligibleFont = {
  standardFont,
  20,
  BorderColor
};

EligibleAsteriskFont = {
  standardFont,
  12,
  BorderColor
};

ConnectingToServerFont = {
	standardFont,
	18,
	BorderColor
};

TableHeaderFont = {
  standardFont,
  30,
  RedColor
};

ScoreInfoFont = {
  standardFont,
  22,
  BorderColor
};


ScoreFont = {
  standardFont,
  18,
  BorderColor
};

RankFont = {
  standardFont,
  26,
  BorderColor
};



UpButtonGraphics = {
	"buttons/arrowup_a.png",
	"buttons/arrowup_b.png",
	"buttons/arrowup_c.png"
};





kScoreRowSpace = 25;
kRowY = 85;
kNumberX = 30;
kNameX = 47;
kNameWidth = 150;
kNameHeight = 18;
kScoreX = 230;
kLevelX = 285;
kP1X = kNumberX + 1;


function ScoreSlot(n)
	return Group {

			
		Text
		{
			font = ScoreFont,
			name = ""..n,
			x=0,y=kRowY+((n-1)*kScoreRowSpace),w=kNumberX,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = n.."."
		};
		
		Bitmap
		{
			image = "hiscore/p1icon.png",
			name = "p1_"..n,
			x=kP1X,y=kRowY+((n-1)*kScoreRowSpace)
		};
		
		AutoFitText
		{
			font = ScoreFont,
			name = "name"..n,
			x=kNameX,y=kRowY+((n-1)*kScoreRowSpace),w=kNameWidth,h=kNameHeight,
			flags = kHAlignLeft + kVAlignTop,
			label = "name"
		};
		
		Text
		{
			font = ScoreFont,
			name = "score"..n,
			x=0,y=kRowY+((n-1)*kScoreRowSpace),w=kScoreX,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "12345"
		};
		
		Text
		{
			font = ScoreFont,
			name = "level"..n,
			x=0,y=kRowY+((n-1)*kScoreRowSpace),w=kLevelX,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "12345"
		};
	}
end

function ScoreSlots()
	t= {}
	for i = 1,10 do
		table.insert(t,ScoreSlot(i))
	end
	return Group(t)
end



MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/high_score_menu_bg",	
		name="hiscorescreen",
		
		HiscoreWindow
		{
			x=0,y=0,h=kMax,w=kMax,
			
			Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=25,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "highscoreheader"
			};
			
			Text
			{
				font = GameModeFont,
				name = "gamemode",
				x=0,y=65,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "GAMEMODE"
			};
			
			Bitmap
			{
				x = 42,
				y = 138,
				w = 343,
				h = 344,
				image="placeholder",
				name="leftpanel",
				
				Text
				{
					font = TableHeaderFont,
					name = "local",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "localhighscores"
				};
				
				
				Text
				{
					font = TableHeaderFont,
					name = "global",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};
				
				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "topplayers"
				};
				
				Text
				{
					font = ScoreFont,
					name = "category",
					x=kCenter,y=40,w=201,h=40,
					flags = kHAlignCenter + kVAlignTop,
					label = "Category Name"
				};
				
				Button
				{
					font = StandardButtonFont,
					graphics = LeftArrowGraphics,
					name="categoryleft",
					label="",
					type = kPush,
					x=kCenter - 100,
					y=35,
					scale = 0.25
				};
				
				Button
				{
					font = StandardButtonFont,
					graphics = LeftArrowGraphics,
					hflip = true,
					name="categoryright",
					label="",
					type = kPush,
					x=kCenter + 100,
					y=35,
					scale = 0.25
				};
				
				
				
				Text
				{
					font = ScoreFont,
					name = "score",
					x=0,y=kRowY-(1*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "score"
				};
				
				Text
				{
					font = ScoreFont,
					name = "level",
					x=0,y=kRowY-(1*kScoreRowSpace),w=kLevelX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "level_lower"
				};
				
				ScoreSlots();
			};
			
			Bitmap
			{
				x = 420,
				y = 150,
				h = 300,
				w = 347,
				
				image="placeholder",	
				name="rightpanelsmall",
				
				Text
				{
					font = ScoreInfoFont,
					name = "yourrankglobalinfo",
					x=10,y=55,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscoreinfo"
				};
				
				Text
				{
					font = RankFont,
					name = "yourrank",
					x=10,y=15,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "yourrank"
				};
				
				Text
				{
					font = RankFont,
					name = "congratulations",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "congratshighscore"
				};
				
				Text
				{
					font = RankFont,
					name = "dnq",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scorednq"
				};
			},
			
			
			Bitmap
			{
				x = 420,
				y = 135,
				h = 315,
				w = 347,
				image="placeholder",	
				name="rightpanel",
				
				Text
				{
					font = TableHeaderFont,
					name = "globalinfoheader",
					x=0,y=8,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};
				
				Text
				{
					font = ScoreInfoFont,
					name = "info",
					x=10,y=55,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscoreinfo"
				};
					
				

				SetStyle(DefaultStyle);
				
				
				
				
				Text
				{
					font = EligibleFont,
					name = "eligible",
					x=10,y=220,w=kMax-10,h=60,
					flags = kHAlignCenter + kVAlignTop,
					label = "eligible"
				};
				
				
			
					
				SetStyle(SmallButtonStyle);
				Button
				{
					x=kCenter,
					y=270,
					name="submit",
					label="submit",
					type = kPush
				};
				
				Button
				{
					x=kCenter,
					y=145,
					name="moreinfo",
					label="moreinfo",
					command =
						function()
							DoModal("scripts/hiscoreinfo.lua");
						end

				};
				SetStyle(DefaultStyle);
			};
			
			
			
			
			
			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=430,y=362,w=327,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "connectingtoserver"
			};
			
			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=485,y=362,w=258,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "Server error"
			};
			
			
			
			
			
			Button
			{
				font = StandardButtonFont,
				graphics = LeftArrowGraphics,
				name="gamemodeleft",
				label="",
				type = kPush,
				x=150,
				y=62,
				scale = 0.4
			};
			
			Button
			{
				font = StandardButtonFont,
				graphics = LeftArrowGraphics,
					hflip = true,
				name="gamemoderight",
				label="",
				type = kPush,
				x=580,
				y=62,
				scale = 0.4
			};
			
			
			
			
			
			Button
			{
				font = StandardButtonFont,
				graphics = UpButtonGraphics,
				name="scrollup",
				label="",
				type = kPush,
				x=335,
				y=225,
				scale = 0.3
			};
			
			Button
			{
				font = StandardButtonFont,
				graphics = UpButtonGraphics,
				vflip = true,
				name="scrolldown",
				label="",
				type = kPush,
				x=335,
				y=445,
				scale = 0.3
			};
			
			SetStyle(LargeButtonStyle);
			
			Button
			{
				x=42,
				y=500,
				name="view",
				label="viewglobal",
			};
						

			Button
			{
				x=42,
				y=500,
				name="viewlocal",
				label="viewlocal",
			};
			
			SetStyle(StandardButtonStyle);
			Button
			{
				x=520,
				y=500,
				name="back",
				flags = kHAlignCenter + kVAlignCenter,
				label="back",
				command = 
					function()
						PopModal("scripts/hiscore.lua");
					end
			};
			SetStyle(DefaultStyle);

			
			
		}
	}
}


if (IsAnonHighScoreMode() == false) then
	EnableWindow('privacy', false);
end

PlayMainMenuMusic();